/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.rtp;

import net.sourceforge.peers.Logger;
import net.sourceforge.peers.rtp.RtpPacket;

public class RtpParser {
    private Logger logger;

    public RtpParser(Logger logger) {
        this.logger = logger;
    }

    public RtpPacket decode(byte[] packet) {
        if (packet.length < 12) {
            this.logger.error("RTP packet too short");
            return null;
        }
        RtpPacket rtpPacket = new RtpPacket();
        int b = packet[0] & 0xFF;
        rtpPacket.setVersion((b & 0xC0) >> 6);
        rtpPacket.setPadding((b & 0x20) != 0);
        rtpPacket.setExtension((b & 0x10) != 0);
        rtpPacket.setCsrcCount(b & 0xF);
        b = packet[1] & 0xFF;
        rtpPacket.setMarker((b & 0x80) != 0);
        rtpPacket.setPayloadType(b & 0x7F);
        b = packet[2] & 0xFF;
        rtpPacket.setSequenceNumber(b * 256 + (packet[3] & 0xFF));
        b = packet[4] & 0xFF;
        rtpPacket.setTimestamp(b * 256 * 256 * 256 + (packet[5] & 0xFF) * 256 * 256 + (packet[6] & 0xFF) * 256 + (packet[7] & 0xFF));
        b = packet[8] & 0xFF;
        rtpPacket.setSsrc(b * 256 * 256 * 256 + (packet[9] & 0xFF) * 256 * 256 + (packet[10] & 0xFF) * 256 + (packet[11] & 0xFF));
        long[] csrcList = new long[rtpPacket.getCsrcCount()];
        for (int i = 0; i < csrcList.length; ++i) {
            csrcList[i] = (packet[12 + i] & 0xFF) << 24 + (packet[12 + i + 1] & 0xFF) << 16 + (packet[12 + i + 2] & 0xFF) << 8 + (packet[12 + i + 3] & 0xFF);
        }
        rtpPacket.setCsrcList(csrcList);
        int dataOffset = 12 + csrcList.length * 4;
        int dataLength = packet.length - dataOffset;
        byte[] data = new byte[dataLength];
        System.arraycopy(packet, dataOffset, data, 0, dataLength);
        rtpPacket.setData(data);
        return rtpPacket;
    }

    public byte[] encode(RtpPacket rtpPacket) {
        byte[] data = rtpPacket.getData();
        int packetLength = 12 + rtpPacket.getCsrcCount() * 4 + data.length;
        byte[] packet = new byte[packetLength];
        int b = (rtpPacket.getVersion() << 6) + ((rtpPacket.isPadding() ? 1 : 0) << 5) + ((rtpPacket.isExtension() ? 1 : 0) << 4) + rtpPacket.getCsrcCount();
        packet[0] = new Integer(b).byteValue();
        b = ((rtpPacket.isMarker() ? 1 : 0) << 7) + rtpPacket.getPayloadType();
        packet[1] = new Integer(b).byteValue();
        b = rtpPacket.getSequenceNumber() >> 8;
        packet[2] = new Integer(b).byteValue();
        b = rtpPacket.getSequenceNumber() & 0xFF;
        packet[3] = new Integer(b).byteValue();
        b = (int)(rtpPacket.getTimestamp() >> 24);
        packet[4] = new Integer(b).byteValue();
        b = (int)(rtpPacket.getTimestamp() >> 16);
        packet[5] = new Integer(b).byteValue();
        b = (int)(rtpPacket.getTimestamp() >> 8);
        packet[6] = new Integer(b).byteValue();
        b = (int)(rtpPacket.getTimestamp() & 0xFFL);
        packet[7] = new Integer(b).byteValue();
        b = (int)(rtpPacket.getSsrc() >> 24);
        packet[8] = new Integer(b).byteValue();
        b = (int)(rtpPacket.getSsrc() >> 16);
        packet[9] = new Integer(b).byteValue();
        b = (int)(rtpPacket.getSsrc() >> 8);
        packet[10] = new Integer(b).byteValue();
        b = (int)(rtpPacket.getSsrc() & 0xFFL);
        packet[11] = new Integer(b).byteValue();
        for (int i = 0; i < rtpPacket.getCsrcCount(); ++i) {
            b = (int)(rtpPacket.getCsrcList()[i] >> 24);
            packet[12 + i * 4] = new Integer(b).byteValue();
            b = (int)(rtpPacket.getCsrcList()[i] >> 16);
            packet[12 + i * 4 + 1] = new Integer(b).byteValue();
            b = (int)(rtpPacket.getCsrcList()[i] >> 8);
            packet[12 + i * 4 + 2] = new Integer(b).byteValue();
            b = (int)(rtpPacket.getCsrcList()[i] & 0xFFL);
            packet[12 + i * 4 + 3] = new Integer(b).byteValue();
        }
        System.arraycopy(data, 0, packet, 12 + rtpPacket.getCsrcCount() * 4, data.length);
        return packet;
    }
}

